/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Last Modification:
    @version $Id: S3M_NRT_Public.h 26976 2012-09-04 09:31:24Z Sven $

  Changes:

      Version    Date         Author    Description
      ---------------------------------------------------------------------------

*******************************************************************************/

#ifndef _SERCOSIIIMASTERNRT_PUBLIC_H_
#define _SERCOSIIIMASTERNRT_PUBLIC_H_

#define SERCOSIIIMASTER_NRT_PROCESS_QUEUE_NAME  "QUE_S3M_NRT"
#define SIII_MA_NRT_PROCESS_QUEUE_NAME SERCOSIIIMASTER_NRT_PROCESS_QUEUE_NAME

#define SIII_MA_NRT_CMD_ENABLE_PROMISC_REQ                0x00005020
#define SIII_MA_NRT_CMD_ENABLE_PROMISC_CNF                0x00005021

#define SIII_MA_NRT_CMD_DISABLE_PROMISC_REQ               0x00005022
#define SIII_MA_NRT_CMD_DISABLE_PROMISC_CNF               0x00005023

/* following request is used by CP task */
#define SIII_MA_NRT_CMD_RESET_MAC_TABLE_REQ               0x00005040
#define SIII_MA_NRT_CMD_RESET_MAC_TABLE_CNF               0x00005041


/******************************************************************************
 * Packet:  SIII_MA_NRT_CMD_ENABLE_PROMISC_REQ/SIII_MA_NRT_CMD_ENABLE_PROMISC_CNF
 */

/* request packet */
typedef struct SIII_MA_NRT_CMD_ENABLE_PROMISC_REQ_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_MA_NRT_CMD_ENABLE_PROMISC_REQ_T, SIII_MA_NRT_ENABLE_PROMISC_REQ_T;


/* confirmation packet */
typedef struct SIII_MA_NRT_CMD_ENABLE_PROMISC_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_MA_NRT_CMD_ENABLE_PROMISC_CNF_T, SIII_MA_NRT_ENABLE_PROMISC_CNF_T;


/* packet union */
typedef struct SIII_MA_NRT_ENABLE_PROMISC_PCK_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_NRT_ENABLE_PROMISC_REQ_T  tReq;
  SIII_MA_NRT_ENABLE_PROMISC_CNF_T  tCnf;
} SIII_MA_NRT_ENABLE_PROMISC_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_NRT_CMD_DISABLE_PROMISC_REQ/SIII_MA_NRT_CMD_DISABLE_PROMISC_CNF
 */

/* request packet */
typedef struct SIII_MA_NRT_CMD_DISABLE_PROMISC_REQ_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_MA_NRT_CMD_DISABLE_PROMISC_REQ_T, SIII_MA_NRT_DISABLE_PROMISC_REQ_T;


/* confirmation packet */
typedef struct SIII_MA_NRT_CMD_DISABLE_PROMISC_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_MA_NRT_CMD_DISABLE_PROMISC_CNF_T, SIII_MA_NRT_DISABLE_PROMISC_CNF_T;

/* packet union */
typedef struct SIII_MA_NRT_DISABLE_PROMISC_PCK_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_NRT_DISABLE_PROMISC_REQ_T   tReq;
  SIII_MA_NRT_DISABLE_PROMISC_CNF_T   tCnf;
} SIII_MA_NRT_DISABLE_PROMISC_PCK_T;


#endif // _SERCOSIIIMASTERNRT_PUBLIC_H_
